
**************************************************************************************************************************************************
******************* Code for 'RBA RDP: Examining the Macroeconomic Costs of Occupational Entry Regulations' *******************
***************************************************** Code for reallocation regressions  ******************************************************************

**************************************************DATE: Jun 2024 ******************************************************************************
**************************************************** AUTHOR: Jonathan Hambur *******************************************************************
*********************************************************************************************************************************************


*** Code strcuture
*00. Preliminaries and globals
*01. Intiail data import and entry/exit construction
*02 Make key variables
*03 Regressions

************* 00. Preliminaries **********

clear

global data ""

global outputs ""
global regs ""

sysdir set PLUS ""
local cuts 1


************* 01. Intiail data import**********


use "$data\full_prod_bit.dta", clear // load in firm level dataset
compress

rename industry anzsic

rename cast_state State
compress

g Y_nom= income
g Yva_nom= income-(totlexps-labour)
g Y = Y_nom/go_ipd_02 // defalte using industry gross output deflatore
g Yva = Yva_nom/va_ipd_02 // defalte using industry gross output deflatore


xtset firmid fyear

** Entry abnd exit measures for other regs
preserve 
egen max_year = max(fyear)
egen min_year = min(fyear)
bysort id (fyear): g entry_all = (_n==1 &  fyear > min_year)
bysort firmid (fyear): g exit_all = (_n == _N & fyear < max_year)
replace exit_all = . if fyear == max_year-1 & fte==. // final sample year for non-employing is 2020 not 2021
collapse(sum) entry_all exit_all (count) firm_all = firmid, by(anzsic fyear State)
save entry_all1, replace
restore

** Versions with only firms with >1 employee
drop if L<`cuts'

preserve 
egen max_year = max(fyear)
egen min_year = min(fyear)
bysort id (fyear): g entry_emp = (_n==1 & fyear > min_year)
bysort firmid (fyear): g exit_emp = (_n == _N & fyear < max_year)
collapse(sum) entry_emp exit_emp (count) firm_emp = firmid, by(anzsic fyear State)
save entry_emp1, replace
restore

************* 02. Make key variables**********

******* Labour productivity measures ***************
g l_prod_fte = Y/fte
g ll_prod_fte = ln(l_prod_fte)
 
g l_prod_fte_va = YVA/fte
g ll_prod_fte_va = ln(l_prod_fte_va)
 

 	xtset firmid fyear
	* EMployment growth - bounded measure
 g dfte = (fte-l.fte)/(0.5*fte+0.5*l.fte) if fte>0 & fte !=. & l.fte>0 & l.fte !=.
 replace dfte = 2 if l.fte ==. & fte > 0 & fyear !=2002
 replace dfte = 2 if l.fte ==0 & fte > 0
	

	
	** Demaean industry prodcutivity
bysort anzsic fyear: egen prod_va_mean = mean(l_prod_fte_va)
bysort anzsic fyear: egen prod_mean = mean(l_prod_fte)


g dev_prod_lva = log(l_prod_fte_va/prod_va_mean)
g dev_prod_l = log(l_prod_fte/prod_mean)

** Size indicators
g small = fte<5
g medium = (fte>4 & fte < 20)
g large = (fte>20 & fte !=.)

g size = 1
replace size = 2 if med == 1
replace size = 3 if large == 1


 g ly=ln(Y_nom)

capture drop _merge

compress
	xtset firmid fyear
	
	
** Indstry by year dummy	
egen ind_yr = group(anzsic fyear)

** Prodcutviity outlier detection
	capture egen dev_prod_lva1 = pctile(dev_prod_lva), p(1)
	capture egen dev_prod_lva99 = pctile(dev_prod_lva), p(99)

	capture egen dev_prod_l1 = pctile(dev_prod_l), p(1)
	capture egen dev_prod_l99 = pctile(dev_prod_l), p(99)
	

	
	
eststo clear



xtset firmid fyear
compress
replace fyear = fyear-2000 // fix if year data been thrown off



merge m:1 anzsic using "$data\occ_lic_state.dta", nogen keep(master match) // merge in OC Lic data

g lic = nsw if State==1
replace lic = vic if State==2
replace lic = qld if State==3



keep if lic!=.

** Unemployment
merge m:1 fyear State using "$data\Unemp.dta",  keep(master match) nogen // merge in state unemployment rates
bysort State: egen mean_unemp_state = mean(Unemp_state)
g demean_unemp_state = Unemp_state - mean_unemp_state
compress
xtset firmid fyear

egen ind_st= group(State anzsic)
egen ind_yr_st= group(State anzsic fyear)

************* 03. Regressions**********
foreach var in dfte  {
eststo clear
** Base regressions - main regs
eststo: areg `var' c.l.dev_prod_lva##c.lic c.l.dev_prod_lva##c.demean_unemp_state  i.State##i.fyear i.size d.l.ly if l.dev_prod_lva>dev_prod_lva1 & l.dev_prod_lva < dev_prod_lva99 , a(ind_yr) vce(cluster ind_st) // no state or industry interaction
eststo: areg `var' c.l.dev_prod_lva##c.lic c.l.dev_prod_lva##c.demean_unemp_state c.l.dev_prod_lva##i.State i.State##i.fyear i.size d.l.ly if l.dev_prod_lva>dev_prod_lva1 & l.dev_prod_lva < dev_prod_lva99 , a(ind_yr) vce(cluster ind_st) // only state itneraction
eststo: areg `var' c.l.dev_prod_lva##c.lic c.l.dev_prod_lva##c.demean_unemp_state c.l.dev_prod_lva##i.anzsic i.State##i.fyear i.size d.l.ly if l.dev_prod_lva>dev_prod_lva1 & l.dev_prod_lva < dev_prod_lva99 , a(ind_yr) vce(cluster ind_st) // CORE REGRESSION
eststo: areg `var' c.l.dev_prod_lva##c.lic c.l.dev_prod_lva##c.demean_unemp_state c.l.dev_prod_lva##i.anzsic c.l.dev_prod_lva##i.State i.State##i.fyear i.size d.l.ly if l.dev_prod_lva>dev_prod_lva1 & l.dev_prod_lva < dev_prod_lva99 , a(ind_yr) vce(cluster ind_st) // both interactions

** regressions 2012 onwards
eststo: areg `var' c.l.dev_prod_lva##c.lic c.l.dev_prod_lva##c.demean_unemp_state  i.State##i.fyear i.size d.l.ly if l.dev_prod_lva>dev_prod_lva1 & l.dev_prod_lva < dev_prod_lva99 & fyear>=2012, a(ind_yr) vce(cluster anzsic) // no state or industry interaction
eststo: areg `var' c.l.dev_prod_lva##c.lic c.l.dev_prod_lva##c.demean_unemp_state c.l.dev_prod_lva##i.State i.State##i.fyear i.size d.l.ly if l.dev_prod_lva>dev_prod_lva1 & l.dev_prod_lva < dev_prod_lva99 & fyear>=2012, a(ind_yr) vce(cluster ind_st) // only state itneraction
eststo: areg `var' c.l.dev_prod_lva##c.lic c.l.dev_prod_lva##c.demean_unemp_state c.l.dev_prod_lva##i.anzsic i.State##i.fyear i.size d.l.ly if l.dev_prod_lva>dev_prod_lva1 & l.dev_prod_lva < dev_prod_lva99 & fyear>=2012, a(ind_yr) vce(cluster ind_st) // CORE REGRESSION
eststo: areg `var' c.l.dev_prod_lva##c.lic c.l.dev_prod_lva##c.demean_unemp_state c.l.dev_prod_lva##i.anzsic c.l.dev_prod_lva##i.State i.State##i.fyear i.size d.l.ly if l.dev_prod_lva>dev_prod_lva1 & l.dev_prod_lva < dev_prod_lva99 & fyear>=2012, a(ind_yr) vce(cluster ind_st)

	esttab using "$regs\realloc_lic_`var'.csv", star(* 0.10 ** 0.05 *** 0.01)  stats(N r2 ar2) se replace	
	eststo clear
	
	
	eststo clear
** REgressions with extra controls (trailed but not main specifciation)
	eststo: areg `var' c.l.dev_prod_lva##c.lic c.l.dev_prod_lva##c.demean_unemp_state  i.size d.l.ly if l.dev_prod_lva>dev_prod_lva1 & l.dev_prod_lva < dev_prod_lva99 , a(ind_yr_st) vce(cluster ind_st) // no state or industry interaction
eststo: areg `var' c.l.dev_prod_lva##c.lic c.l.dev_prod_lva##c.demean_unemp_state c.l.dev_prod_lva##i.State  i.size d.l.ly if l.dev_prod_lva>dev_prod_lva1 & l.dev_prod_lva < dev_prod_lva99 , a(ind_yr_st) vce(cluster ind_st) // only state itneraction
eststo: areg `var' c.l.dev_prod_lva##c.lic c.l.dev_prod_lva##c.demean_unemp_state c.l.dev_prod_lva##i.anzsic  i.size d.l.ly if l.dev_prod_lva>dev_prod_lva1 & l.dev_prod_lva < dev_prod_lva99 , a(ind_yr_st) vce(cluster ind_st)
eststo: areg `var' c.l.dev_prod_lva##c.lic c.l.dev_prod_lva##c.demean_unemp_state c.l.dev_prod_lva##i.anzsic c.l.dev_prod_lva##i.State  i.size d.l.ly if l.dev_prod_lva>dev_prod_lva1 & l.dev_prod_lva < dev_prod_lva99 , a(ind_yr_st) vce(cluster ind_st) // both interactions

eststo: areg `var' c.l.dev_prod_lva##c.lic c.l.dev_prod_lva##c.demean_unemp_state   i.size d.l.ly if l.dev_prod_lva>dev_prod_lva1 & l.dev_prod_lva < dev_prod_lva99 & fyear>=2012, a(ind_yr_st) vce(cluster anzsic) // no state or industry interaction
eststo: areg `var' c.l.dev_prod_lva##c.lic c.l.dev_prod_lva##c.demean_unemp_state c.l.dev_prod_lva##i.State i.size d.l.ly if l.dev_prod_lva>dev_prod_lva1 & l.dev_prod_lva < dev_prod_lva99 & fyear>=2012, a(ind_yr_st) vce(cluster ind_st) // only state itneraction
eststo: areg `var' c.l.dev_prod_lva##c.lic c.l.dev_prod_lva##c.demean_unemp_state c.l.dev_prod_lva##i.anzsic  i.size d.l.ly if l.dev_prod_lva>dev_prod_lva1 & l.dev_prod_lva < dev_prod_lva99 & fyear>=2012, a(ind_yr_st) vce(cluster ind_st)
eststo: areg `var' c.l.dev_prod_lva##c.lic c.l.dev_prod_lva##c.demean_unemp_state c.l.dev_prod_lva##i.anzsic c.l.dev_prod_lva##i.State   i.size d.l.ly if l.dev_prod_lva>dev_prod_lva1 & l.dev_prod_lva < dev_prod_lva99 & fyear>=2012, a(ind_yr_st) vce(cluster ind_st) // both interactions


	esttab using "$regs\realloc_lic_`var'_sst.csv", star(* 0.10 ** 0.05 *** 0.01)  stats(N r2 ar2) se replace	
	eststo clear
	
}


preserve

** Test removing civil engineerign as robusness
foreach var in dfte  {
	
	drop if inlist(anzsic,3101 , 3109, 6923)

eststo: areg `var' c.l.dev_prod_lva##c.lic c.l.dev_prod_lva##c.demean_unemp_state c.l.dev_prod_lva##i.anzsic i.State##i.fyear i.size d.l.ly if l.dev_prod_lva>dev_prod_lva1 & l.dev_prod_lva < dev_prod_lva99 , a(ind_yr) vce(cluster ind_st)
eststo: areg `var' c.l.dev_prod_lva##c.lic c.l.dev_prod_lva##c.demean_unemp_state c.l.dev_prod_lva##i.anzsic i.State##i.fyear i.size d.l.ly if l.dev_prod_lva>dev_prod_lva1 & l.dev_prod_lva < dev_prod_lva99 & period1==3, a(ind_yr) vce(cluster ind_st)



	esttab using "$regs\realloc_lic_ncivil_`var'.csv", star(* 0.10 ** 0.05 *** 0.01)  stats(N r2 ar2) se replace	
	eststo clear
	
}


	restore
